/*
 * Decompiled with CFR 0.152.
 */
package org.jetlang.fibers;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetlang.core.Disposable;
import org.jetlang.fibers.Fiber;

public class FiberStub
implements Fiber {
    public List<Disposable> Disposables = new ArrayList<Disposable>();
    public List<Runnable> Pending = new ArrayList<Runnable>();
    public List<ScheduledEvent> Scheduled = new ArrayList<ScheduledEvent>();

    @Override
    public void start() {
    }

    @Override
    public void add(Disposable disposable) {
        this.Disposables.add(disposable);
    }

    @Override
    public boolean remove(Disposable disposable) {
        return this.Disposables.remove(disposable);
    }

    @Override
    public int size() {
        return this.Disposables.size();
    }

    @Override
    public void execute(Runnable command) {
        this.Pending.add(command);
    }

    @Override
    public Disposable schedule(Runnable runnable, long l, TimeUnit timeUnit) {
        final ScheduledEvent event = new ScheduledEvent(runnable, l, timeUnit);
        this.Scheduled.add(event);
        return new Disposable(){

            @Override
            public void dispose() {
                FiberStub.this.Scheduled.remove(event);
            }
        };
    }

    @Override
    public Disposable scheduleAtFixedRate(Runnable runnable, long first, long interval, TimeUnit timeUnit) {
        final ScheduledEvent event = new ScheduledEvent(runnable, first, interval, timeUnit);
        this.Scheduled.add(event);
        return new Disposable(){

            @Override
            public void dispose() {
                FiberStub.this.Scheduled.remove(event);
            }
        };
    }

    @Override
    public Disposable scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.scheduleAtFixedRate(command, initialDelay, delay, unit);
    }

    @Override
    public void dispose() {
    }

    public void executeAllPending() {
        for (Runnable runnable : new ArrayList<Runnable>(this.Pending)) {
            runnable.run();
            this.Pending.remove(runnable);
        }
    }

    public void executeAllScheduled() {
        for (ScheduledEvent event : new ArrayList<ScheduledEvent>(this.Scheduled)) {
            event.getRunnable().run();
            if (event.isRecurring()) continue;
            this.Scheduled.remove(event);
        }
    }

    public static class ScheduledEvent {
        private final Runnable runnable;
        private final long first;
        private final long interval;
        private final TimeUnit timeUnit;
        private final boolean isRecurring;

        public ScheduledEvent(Runnable runnable, long time, TimeUnit timeUnit) {
            this(runnable, time, -1L, timeUnit, false);
        }

        public ScheduledEvent(Runnable runnable, long first, long interval, TimeUnit timeUnit, boolean recurring) {
            this.runnable = runnable;
            this.first = first;
            this.interval = interval;
            this.timeUnit = timeUnit;
            this.isRecurring = recurring;
        }

        public ScheduledEvent(Runnable runnable, long first, long interval, TimeUnit timeUnit) {
            this(runnable, first, interval, timeUnit, true);
        }

        public Runnable getRunnable() {
            return this.runnable;
        }

        public long getFirst() {
            return this.first;
        }

        public long getInterval() {
            return this.interval;
        }

        public TimeUnit getTimeUnit() {
            return this.timeUnit;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ScheduledEvent event = (ScheduledEvent)o;
            if (this.first != event.first) {
                return false;
            }
            if (this.interval != event.interval) {
                return false;
            }
            if (this.isRecurring != event.isRecurring) {
                return false;
            }
            if (this.runnable != null ? !this.runnable.equals(event.runnable) : event.runnable != null) {
                return false;
            }
            return this.timeUnit == event.timeUnit;
        }

        public int hashCode() {
            int result = this.runnable != null ? this.runnable.hashCode() : 0;
            result = 31 * result + (int)(this.first ^ this.first >>> 32);
            result = 31 * result + (int)(this.interval ^ this.interval >>> 32);
            result = 31 * result + (this.timeUnit != null ? this.timeUnit.hashCode() : 0);
            result = 31 * result + (this.isRecurring ? 1 : 0);
            return result;
        }

        public boolean isRecurring() {
            return this.isRecurring;
        }

        public void run() {
            this.runnable.run();
        }
    }
}

