/*
 * Decompiled with CFR 0.152.
 */
package org.jetlang.fibers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.jetlang.core.BatchExecutor;
import org.jetlang.core.Disposable;
import org.jetlang.core.EventBuffer;
import org.jetlang.core.SchedulerImpl;
import org.jetlang.fibers.ExecutionState;
import org.jetlang.fibers.Fiber;

class PoolFiber
implements Fiber {
    private final SynchronizedQueue _queue = new SynchronizedQueue();
    private final Executor _flushExecutor;
    private final AtomicReference<ExecutionState> _started = new AtomicReference<ExecutionState>(ExecutionState.Created);
    private final BatchExecutor _commandExecutor;
    private final Collection<Disposable> _disposables = Collections.synchronizedList(new ArrayList());
    private final SchedulerImpl _scheduler;
    private final Runnable _flushRunnable;
    private EventBuffer buffer = new EventBuffer();

    public PoolFiber(Executor pool, BatchExecutor executor, ScheduledExecutorService scheduler) {
        this._flushExecutor = pool;
        this._commandExecutor = executor;
        this._scheduler = new SchedulerImpl(this, scheduler);
        this._flushRunnable = new Runnable(){

            @Override
            public void run() {
                PoolFiber.this.flush();
            }
        };
    }

    @Override
    public void execute(Runnable commands) {
        if (this._started.get() == ExecutionState.Stopped) {
            return;
        }
        this._queue.put(commands);
    }

    private void flush() {
        EventBuffer swap = this._queue.swap(this.buffer);
        while (swap != null) {
            this.buffer = swap;
            this._commandExecutor.execute(this.buffer);
            this.buffer.clear();
            swap = this._queue.swap(this.buffer);
        }
    }

    @Override
    public void start() {
        ExecutionState state = this._started.get();
        if (state == ExecutionState.Running) {
            throw new RuntimeException("Already Started");
        }
        if (this._started.compareAndSet(state, ExecutionState.Running)) {
            this._queue.setRunning(true);
            this.execute(new Runnable(){

                @Override
                public void run() {
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        this._queue.setRunning(false);
        this._started.set(ExecutionState.Stopped);
        Collection<Disposable> collection = this._disposables;
        synchronized (collection) {
            for (Disposable r : this._disposables.toArray(new Disposable[this._disposables.size()])) {
                r.dispose();
            }
        }
    }

    @Override
    public void add(Disposable runOnStop) {
        this._disposables.add(runOnStop);
    }

    @Override
    public boolean remove(Disposable disposable) {
        return this._disposables.remove(disposable);
    }

    @Override
    public int size() {
        return this._disposables.size();
    }

    @Override
    public Disposable schedule(Runnable command, long delay, TimeUnit unit) {
        return this._scheduler.schedule(command, delay, unit);
    }

    @Override
    public Disposable scheduleAtFixedRate(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.register(this._scheduler.scheduleAtFixedRate(command, initialDelay, delay, unit));
    }

    @Override
    public Disposable scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.register(this._scheduler.scheduleWithFixedDelay(command, initialDelay, delay, unit));
    }

    private Disposable register(final Disposable stopper) {
        Disposable wrapper = new Disposable(){

            @Override
            public void dispose() {
                stopper.dispose();
                PoolFiber.this.remove(this);
            }
        };
        this.add(wrapper);
        return wrapper;
    }

    private class SynchronizedQueue {
        private boolean running = false;
        private boolean flushPending = false;
        private EventBuffer queue = new EventBuffer();

        private SynchronizedQueue() {
        }

        private synchronized void setRunning(boolean newValue) {
            this.running = newValue;
        }

        private synchronized void put(Runnable r) {
            this.queue.add(r);
            if (this.running && !this.flushPending) {
                PoolFiber.this._flushExecutor.execute(PoolFiber.this._flushRunnable);
                this.flushPending = true;
            }
        }

        private synchronized EventBuffer swap(EventBuffer buffer) {
            if (this.queue.isEmpty() || !this.running) {
                this.flushPending = false;
                return null;
            }
            EventBuffer toReturn = this.queue;
            this.queue = buffer;
            return toReturn;
        }
    }
}

