/*
 * Decompiled with CFR 0.152.
 */
package mage.player.ai;

import java.util.UUID;
import java.util.concurrent.Callable;
import mage.game.Game;
import mage.player.ai.ComputerPlayerMCTS;
import mage.player.ai.MCTSNode;
import org.apache.log4j.Logger;

public class MCTSExecutor
implements Callable<Boolean> {
    protected transient MCTSNode root;
    protected int thinkTime;
    protected UUID playerId;
    protected int simCount;
    private static final Logger logger = Logger.getLogger(ComputerPlayerMCTS.class);

    public MCTSExecutor(Game sim, UUID playerId, int thinkTime) {
        this.playerId = playerId;
        this.thinkTime = thinkTime;
        this.root = new MCTSNode(playerId, sim);
    }

    @Override
    public Boolean call() {
        this.simCount = 0;
        while (true) {
            int result;
            MCTSNode current = this.root;
            while (!current.isLeaf()) {
                current = current.select(this.playerId);
            }
            if (!current.isTerminal()) {
                current.expand();
                if (current.getNumChildren() > 1) {
                    current = current.select(this.playerId);
                    result = current.simulate(this.playerId);
                    ++this.simCount;
                } else {
                    current = current.select(this.playerId);
                    result = 0;
                }
            } else {
                result = current.isWinner(this.playerId) ? 1 : -1;
            }
            current.backpropagate(result);
        }
    }

    public MCTSNode getRoot() {
        return this.root;
    }

    public void clear() {
        this.root = null;
    }

    public int getSimCount() {
        return this.simCount;
    }
}

