/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.key.console;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Console;
import java.io.PrintWriter;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.ResourceBundle;
import javax.annotation.concurrent.ThreadSafe;
import net.java.truecommons.key.spec.KeyStrength;
import net.java.truecommons.key.spec.prompting.KeyPromptingDisabledException;
import net.java.truecommons.key.spec.prompting.PromptingKey;
import net.java.truecommons.key.spec.prompting.PromptingPbeParameters;

@ThreadSafe
abstract class ConsolePromptingPbeParametersView<P extends PromptingPbeParameters<P, S>, S extends KeyStrength>
implements PromptingKey.View<P> {
    private static final ResourceBundle resources = ResourceBundle.getBundle(ConsolePromptingPbeParametersView.class.getName());
    private static final Object lock = new Object();
    private static final int MIN_PASSWD_LEN = 8;
    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"})
    private static URI lastResource = URI.create("");
    private static final String YES = resources.getString("yes");
    private static final String NO = resources.getString("no");

    ConsolePromptingPbeParametersView() {
    }

    protected abstract P newPbeParameters();

    public final void promptKeyForWriting(final PromptingKey.Controller<P> controller) throws KeyPromptingDisabledException {
        this.promptKey(new KeyPrompt(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void promptKey(Console con) {
                URI resource = controller.getResource();
                assert (null != resource);
                if (!lastResource.equals(resource)) {
                    con.format(resources.getString("writeKey.banner"), resource);
                }
                lastResource = resource;
                Object param = (PromptingPbeParameters)controller.getKeyClone();
                if (null == param) {
                    param = ConsolePromptingPbeParametersView.this.newPbeParameters();
                }
                while (true) {
                    char[] input1;
                    if (null == (input1 = con.readPassword(resources.getString("writeKey.newPasswd1"), new Object[0])) || 0 >= input1.length) {
                        return;
                    }
                    if (8 > input1.length) {
                        con.format(resources.getString("writeKey.passwd.tooShort"), 8);
                        continue;
                    }
                    try {
                        char[] input2;
                        block22: {
                            input2 = con.readPassword(resources.getString("writeKey.newPasswd2"), new Object[0]);
                            if (input2 == null) {
                                return;
                            }
                            try {
                                if (Arrays.equals(input1, input2)) break block22;
                                con.format(resources.getString("writeKey.passwd.noMatch"), new Object[0]);
                            }
                            catch (Throwable throwable) {
                                Arrays.fill(input2, '\u0000');
                                throw throwable;
                            }
                            Arrays.fill(input2, '\u0000');
                            continue;
                        }
                        param.setPassword(input1);
                        Arrays.fill(input2, '\u0000');
                    }
                    finally {
                        Arrays.fill(input1, '\u0000');
                        continue;
                    }
                    break;
                }
                con.format(resources.getString("keyStrength.banner"), new Object[0]);
                StringBuilder builder = new StringBuilder();
                KeyStrength[] array = param.getAllKeyStrengths();
                HashMap<Integer, KeyStrength> map = new HashMap<Integer, KeyStrength>(array.length / 3 * 4 + 1);
                PrintWriter writer = con.writer();
                for (KeyStrength strength : array) {
                    if (0 < builder.length()) {
                        builder.append('/');
                    }
                    builder.append(strength.getBits());
                    map.put(strength.getBits(), strength);
                    writer.println(strength);
                }
                String selection = builder.toString();
                while (true) {
                    KeyStrength keyStrength = param.getKeyStrength();
                    String input = con.readLine(resources.getString("keyStrength.prompt"), selection, null == keyStrength ? 0 : keyStrength.getBits());
                    if (null == input || input.length() <= 0) break;
                    try {
                        int bits = Integer.parseInt(input);
                        KeyStrength strength = (KeyStrength)map.get(bits);
                        if (null == strength) continue;
                        assert (strength.getBits() == bits);
                        param.setKeyStrength(strength);
                    }
                    catch (NumberFormatException numberFormatException) {
                        continue;
                    }
                    break;
                }
                controller.setKeyClone((PromptingKey)param);
            }
        });
    }

    public void promptKeyForReading(final PromptingKey.Controller<P> controller, final boolean invalid) throws KeyPromptingDisabledException {
        this.promptKey(new KeyPrompt(){

            @Override
            public void promptKey(Console con) {
                String changeKey;
                if (invalid) {
                    con.format(resources.getString("readKey.invalid"), new Object[0]);
                }
                URI resource = controller.getResource();
                assert (null != resource);
                if (!lastResource.equals(resource)) {
                    con.format(resources.getString("readKey.banner"), resource);
                }
                lastResource = resource;
                char[] passwd = con.readPassword(resources.getString("readKey.passwd"), new Object[0]);
                if (null == passwd || passwd.length <= 0) {
                    controller.setKeyClone(null);
                    return;
                }
                Object param = ConsolePromptingPbeParametersView.this.newPbeParameters();
                param.setPassword(passwd);
                Arrays.fill(passwd, '\u0000');
                do {
                    changeKey = con.readLine(resources.getString("readKey.change"), new Object[0]);
                    param.setChangeRequested(YES.equalsIgnoreCase(changeKey));
                } while (null != changeKey && changeKey.length() > 0 && !YES.equalsIgnoreCase(changeKey) && !NO.equalsIgnoreCase(changeKey));
                controller.setKeyClone(param);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void promptKey(KeyPrompt keyPrompt) throws KeyPromptingDisabledException {
        Console con = System.console();
        if (null == con) {
            throw new KeyPromptingDisabledException();
        }
        Object object = lock;
        synchronized (object) {
            keyPrompt.promptKey(con);
        }
    }

    private static interface KeyPrompt {
        public void promptKey(Console var1);
    }
}

